IF EXISTS(SELECT * 
		FROM SYS.SYSOBJECTS 
		WHERE NAME ='P_EST_WMS_SAI_VOLUME_PEND_EXECUTE_ALL' AND TYPE=N'P')
BEGIN
	DROP PROCEDURE P_EST_WMS_SAI_VOLUME_PEND_EXECUTE_ALL
END
GO
GO

SET ANSI_NULLS ON  
SET QUOTED_IDENTIFIER ON 
GO
/*
***********************************************************************
	Este job esta sendo executado pela procedure P_INCLUI_PENDENCIA_WMS
***********************************************************************
*/
CREATE PROCEDURE [dbo].[P_EST_WMS_SAI_VOLUME_PEND_EXECUTE_ALL] AS
DECLARE @CD_EMP INT
DECLARE @CD_FILIAL INT
DECLARE @CD_CTR INT
DECLARE @CD_PED_WMS INT


SET NOCOUNT on;
PRINT 'Processamento volume pendente ' 
DECLARE CProcVolumePendente CURSOR FAST_FORWARD FOR 
											SELECT
	DISTINCT R.CD_EMP,
			R.CD_FILIAL,
			R.CD_CTR,
			R.CD_PED_WMS
FROM
	EST_WMS_SAI_VOLUME_PEND INNER JOIN EST_PROD_TRANSF_EST_WMS_SAI r ON
	EST_WMS_SAI_VOLUME_PEND.CD_PED_WMS = r.CD_PED_WMS 

OPEN CProcVolumePendente
FETCH NEXT FROM CProcVolumePendente INTO @CD_EMP,
										@CD_FILIAL,
										@CD_CTR,
										@CD_PED_WMS
WHILE @@FETCH_STATUS=0
  begin
	PRINT	'  Analise wms ' + convert(varchar(5), @CD_PED_WMS)+ ' ressuprimento ' + convert(varchar(5), @CD_CTR) + 
			' (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...'

	EXEC P_EST_WMS_SAI_SAI_VOLUME_PROCESSAR @CD_EMP,@CD_FILIAL,@CD_CTR,@CD_PED_WMS
	
FETCH NEXT FROM CProcVolumePendente INTO @CD_EMP,
										@CD_FILIAL,
										@CD_CTR,
										@CD_PED_WMS
  end
PRINT 'Concludo.'
CLOSE CProcVolumePendente
DEALLOCATE CProcVolumePendente
